/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/
#include "GetInputFocusCommand.h"
#include "Surface.h"
#include "ICommandExecutor.h"
#include "Scene.h"
#include "Log.h"
#include "RendererList.h"
#include "InputManager.h"

ExecutionResult GetInputFocusCommand::execute(ICommandExecutor* executor)
{
    Scene& scene = *(executor->getScene());
    SurfaceMap allSurfaces;
    ExecutionResult result = ExecutionFailed;
    unsigned int numSurfaces;
    unsigned int surfCount = 0;

    allSurfaces = scene.getAllSurfaces();
    numSurfaces = allSurfaces.size();

    if ((NULL != m_pSurfIDArray) && (NULL != m_pBitmaskArray) && (NULL != m_pNumSurfaces))
    {
        *m_pNumSurfaces = 0;
        if (numSurfaces > 0)
        {
            *m_pSurfIDArray = (t_ilm_surface*)malloc(sizeof(unsigned int) * numSurfaces);
            if (NULL != *m_pSurfIDArray)
            {
                *m_pBitmaskArray = (ilmInputDevice*)malloc(sizeof(ilmInputDevice) * numSurfaces);
                if (NULL != *m_pBitmaskArray)
                {
                    for (SurfaceMap::const_iterator currentS = allSurfaces.begin();
                        currentS != allSurfaces.end(); ++currentS, ++surfCount)
                    {
                        Surface* currentSurface = (*currentS).second;
                        (*m_pSurfIDArray)[surfCount] = currentSurface->getID();
                        (*m_pBitmaskArray)[surfCount] = currentSurface->getFocusBitmap();
                    }
                    *m_pNumSurfaces = surfCount;
                    result = ExecutionSuccess;
                }
                else
                {
                    free(*m_pSurfIDArray);
                }
            }
        }
        else
        {
            result = ExecutionSuccess;
        }
    }
    return result;
}

const std::string GetInputFocusCommand::getString()
{
    std::stringstream description;
    description << "GetInputFocusCommand("
                << ")";
    return description.str();
}
